<?php
/************** Products WIDGET ********************/
class Button_Widget extends WP_Widget {

  /**
   * Register widget with WordPress.
   */
  function __construct() {
    parent::__construct(
      'button_widget', // Base ID
      __('Custom Button', '_tk'), // Name
      array( 'description' => __( 'Widget that displays custom button', '_tk' ), ) // Args
    );
  }

  /* Front-end display of widget. */
  public function widget( $args, $instance ) {
    echo $args['before_widget'];
    if ( !empty($instance['title']) ) {
      echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
    } ?>
	
	<?php 
	$link_file = get_field('link_file', 'widget_' . $args['widget_id']);
	$link_cat = get_field('link_cat', 'widget_' . $args['widget_id']); ?>
	<a href="<?php if (get_field('link_source', 'widget_' . $args['widget_id']) == 'site' and get_field('link_site', 'widget_' . $args['widget_id'])) the_field('link_site', 'widget_' . $args['widget_id']); elseif (get_field('link_source', 'widget_' . $args['widget_id']) == 'url' and get_field('link_url', 'widget_' . $args['widget_id'])) the_field('link_url', 'widget_' . $args['widget_id']); elseif (get_field('link_source', 'widget_' . $args['widget_id']) == 'cat' and get_term_link($link_cat)) echo $link_file['url']; elseif (get_field('link_source', 'widget_' . $args['widget_id']) == 'file' and $link_file) echo $link_file['url']; ?>" class="wow fadeIn <?php if (get_field('link_type', 'widget_' . $args['widget_id']) == 'default') echo 'btn btn-default';  elseif (get_field('link_type', 'widget_' . $args['widget_id']) == 'primary') echo 'btn btn-primary'; else echo 'normal-link'; ?>"<?php if (get_field('link_source', 'widget_' . $args['widget_id']) == 'url' and (get_field('link_url', 'widget_' . $args['widget_id']) or $link_file)) { ?> target="_blank"<?php } ?>>
		<?php if (get_field('link_content', 'widget_' . $args['widget_id'])) { ?>
			<?php the_field('link_icon', 'widget_' . $args['widget_id']) ?> <?php the_field('link_content', 'widget_' . $args['widget_id']) ?>
		<?php } else { ?>
			Czytaj więcej
		<?php } ?>
	</a>
    
	
	<?php echo $args['after_widget'];
  }

  /**
   * Back-end widget form.
   *
   * @see WP_Widget::form()
   *
   * @param array $instance Previously saved values from database.
   */
  public function form( $instance ) {
    if ( isset($instance['title']) ) {
      $title = $instance['title'];
    }
    else {
      $title = __( 'Widget title', '_tk' );
    }
    ?>
    <p>
      <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label>
      <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="" placeholder="<?php echo esc_attr( $title ); ?>">
    </p>
    <?php
  }

  /**
   * Sanitize widget form values as they are saved.
   *
   * @see WP_Widget::update()
   *
   * @param array $new_instance Values just sent to be saved.
   * @param array $old_instance Previously saved values from database.
   *
   * @return array Updated safe values to be saved.
   */
  public function update( $new_instance, $old_instance ) {
    $instance = array();
    $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';

    return $instance;
  }

} // class Button_Widget

// register Button_Widget widget
add_action( 'widgets_init', function(){
  register_widget( 'Button_Widget' );
});

?>